
// stringify.h
// Copyright 2015 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef STRINGIFY_H
#define STRINGIFY_H

#include <sstream>

std::string stringify(short a);
std::string stringify(unsigned short a);
std::string stringify(int a);
std::string stringify(unsigned int a);
std::string stringify(long a);
std::string stringify(unsigned long a);
std::string stringify(long long a);
std::string stringify(unsigned long long a);
std::string stringify(float a);
std::string stringify(double a);
std::string stringify(const std::string &a);
std::string stringify(const tm &a);

template<class A> std::string stringify(A a) {
  std::ostringstream oss;
  oss << a;
  return oss.str();
}

struct String {
  String(const char *s);
  String(const std::string &s);
  const char *s;
  operator const char *() const;
};

#endif

