
// logMsg.h
// Copyright 2015 Matthew Rickard
// This file is part of dep

// dep is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

#ifndef LOGMSG_H
#define LOGMSG_H

#include <iostream>
#include <string>

#include "Utils.h"

#define LOGMSG_ENABLED 1

#define logLine logLine_fn(__FILE__, __LINE__, __FUNCTION__)

// logFn omits the line number. This makes it good for unit testing

#define logFn std::string(2 * logMsgIndent, ' ') \
  << BaseName(__FILE__) << ' ' << __FUNCTION__ << ' '

#define logMsg *logStream() << logLine_fn(__FILE__, __LINE__, __FUNCTION__)

#define logValue(a) #a "=" << (a)
#define currentLine FileLine(__FILE__, __LINE__)

extern int logMsgIndent;

struct LogMsgIndenter {
  LogMsgIndenter();
  ~LogMsgIndenter();
  void close();
  int closed;
};

std::string logLine_fn(const char *file, int line, const char *fn);

std::ostream *logStream();

#endif

